#import "@preview/cetz:0.3.4"

// Colors
#let color-tokiwa = rgb("#1f9967")

// Mathematics
#let vec(content) = math.bold[#content]
#let select(content) = math.acute[#content]
#let Symbols = math.upright("Symbols")
#let argmax = math.op("arg max", limits: true)
#let Prop = math.upright("Prop")
#let type = math.op("type")
#let Entails = math.tack.r
#let Func = math.lambda
#let Mapsto = math.arrow.r.bar
#let Fuzz = math.psi
#let Nat = math.NN
#let Int = math.ZZ
#let goal(name) = text(fill: purple)[$?#h(-1pt)#name$]
#let tactic(content) = math.op(text(font: "DejaVu Sans Mono", size: 10pt)[#content])

// Drawing
#let Goal(body, pos: (0, 0), name: "goal", ..args) = {
  import cetz.draw: content;
  content(
    pos,
    box(
      stroke: maroon,
      inset: ("top": .6em, "bottom": .4em, "left": .5em, "right": .5em),
      radius: .5em,
    )[
      #body
    ],
    name: name,
    ..args
  )
}
#let GoalState(goals, name: "s") = {
  import cetz.draw: group, rect, on-layer;
  let color = silver.transparentize(90%)
  group(goals, name: name, padding: .3em)
  on-layer(-1,
    rect(name + ".south-west", name + ".north-east",
      stroke: 1pt + gray,
      name: name + "-state",
      fill: color))
}
#let GoalStateEmpty(pos, name: "state") = {
  import cetz.draw: content;
  GoalState(
    { content(pos)[] },
    name: name
  )
}
#let EdgeTactic(..args) = {
  import cetz.draw: line;
  line(..args, stroke: 1pt + blue, mark: (end: ">"))
}
#let EdgeCoupling(src, dst, ..args) = {
  import cetz.draw: line, mark;
  let c = fuchsia.transparentize(70%)
  line(src, dst, ..args, stroke: 3pt + c, name: "l", mark: (end: ">"))
}
#let EdgeResumeState(..args) = {
  import cetz.draw: line;
  line(..args, stroke: 2pt + olive.transparentize(50%), mark: (end: "[]"))
}
#let EdgeResume(..args) = {
  import cetz.draw: line;
  line(..args, stroke: 1pt + olive.transparentize(50%), mark: (end: "[]"))
}
#let EdgeResumeInPassing(..args) = {
  import cetz.draw: line, mark;
  line(..args, stroke: (thickness: 1pt, paint: olive.transparentize(50%), dash: "dashed"), mark: (end: "[]"))
}
#let LabelTactic(body, pos: (0,0), ..styles) = {
  import cetz.draw: content;
  content(pos, body,
    color: green, padding: .1,
    ..styles)
}