// This theme is from https://github.com/andreasKroepelin/polylux/blob/main/themes/simple.typ
// Author: Andreas Kröpelin

#import "@preview/touying:0.6.0": *
#import themes.simple: *

// https://forum.typst.app/t/how-to-auto-size-text-and-images/1290
#let fill-height-with-text(min: 0.3em, max: 5em, eps: 0.1em, by-guess: false, debug: false, it) = layout(size => {
  let size-of-text = (text-size, it) => (
    measure(
      width: size.width,
      {
        set text(text-size)
        it
      },
    ).height
  )

  let fits(text-size, it) = {
    (
      size-of-text(text-size, it) <= size.height
    )
  }

  let debug-msg = []
  (
    if fits(max, it) {
      debug-msg += "1 render"
      set text(max)
      it
    } else if not fits(min, it) {
      debug-msg += "Failed: min size too large"
      it
    } else {
      if by-guess {
        let guess = 1em * (size.height / size-of-text(1em, it))
        debug-msg += [guess #repr(guess)]
        set text(guess)
        it
      } else {
        let (a, b) = (min, max)
        let cnt = 0

        while b - a > eps {
          cnt += 1
          let new = 0.5 * (a + b)
          if fits(new, it) {
            a = new
          } else {
            b = new
          }
        }

        debug-msg += [#cnt renders]

        set text(a)
        it
      }
    }
      + if debug and debug-msg != [] {
        place(
          top + right,
          block(
            fill: teal.transparentize(50%),
            inset: 6pt,
            text(16pt)[
              #debug-msg
            ],
          ),
        )
      } else []
  )
})

#let adaptive-composer = (
  composer: auto,
  debug: false,
  precise-size: true,
  guess: false,
  ..bodies,
) => components.side-by-side(
  composer: composer,
  ..bodies
    .pos()
    .map(it => block(
      height: 1fr,
      fill-height-with-text(
        max: 1em,
        eps: if precise-size {
          0.01em
        } else {
          0.5em
        },
        debug: debug,
        by-guess: guess,
        it,
      ),
    )),
);

#let slide_ = slide

#let slide = (debug: false, precise-size: true, guess: false, ..args) => {
  return slide(
  composer: adaptive-composer.with(debug: debug, precise-size: precise-size, guess: guess),
  ..args,
  )
}

/// Centered slide for the presentation.
#let centered-slide(..args) = touying-slide-wrapper(self => {
  touying-slide(self: self, ..args.named(), align(center + horizon, args.pos().sum(default: none)))
})


/// Title slide for the presentation.
#let title-slide(header: "", footer: "Copyright", ..args) = touying-slide-wrapper(self => {
  touying-slide(
    self: self,
    config: utils.merge-dicts(
      config-common(freeze-slide-counter: true, subslide-preamble: ""),
      config-page(
        header: "",
        footer: text(
          size: .7em,
          footer,
        ),
      ),
    ),
    ..args.named(),
    align(horizon, args.pos().sum(default: none)),
  )
})


/// New section slide for the presentation. You can update it by updating the `new-section-slide-fn` argument for `config-common` function.
#let new-section-slide(body) = centered-slide([
  #text(1.2em, weight: "bold", utils.display-current-heading(level: 1))

  #body
])


/// Focus on some content.
///
/// Example: `#focus-slide[Wake up!]`
#let focus-slide(background: auto, foreground: white, body) = touying-slide-wrapper(self => {
  self = utils.merge-dicts(
    self,
    config-common(freeze-slide-counter: true),
    config-page(
      fill: if background == auto {
        self.colors.primary
      } else {
        background
      },
    ),
  )
  set text(fill: foreground, size: 1.5em)
  touying-slide(self: self, align(center + horizon, body))
})


#let theme = (debug: false, precise-size: true, guess: false, ..args) => simple-theme(
  primary: black,
  config-common(slide-fn: slide.with(debug: debug, precise-size: precise-size, guess: guess)),
  ..args,
)
