#import "@preview/touying:0.6.0": *
#import "@preview/codly:1.0.0": *
#import "theme.typ": *

#set text(font: "IBM Plex Sans")
#set par(justify: true)
#show: codly-init.with()

#codly(zebra-fill: none, fill: luma(250), stroke: 1pt + luma(220), number-format: none, lang-format: none)

#show raw.where(block: false): it => box(inset: (x: 0.4em), box(outset: 0.4em, radius: 0.1em, fill: luma(240), it))

#show link: it => text(fill: blue, it)

#show: theme.with(
  aspect-ratio: "16-9",
  debug: false,
  precise-size: true,
  guess: true, // true for realtime editing, false for final rendering
  header: self => [],
)

#let smcp(s) = (
  s
    .clusters()
    .map(c => if c.contains(regex("[A-Z]")) {
      c
    } else if c.contains(regex("[a-z]")) {
      text(size: 0.8em, upper(c))
    } else {
      c
    })
    .join()
)

#let msmcp(s) = $upright(#text(size:0.8em, smcp(s)))$

#let value = $bold("value")$
#let svalue = $bold("👍value")$
#let st = $bold("👍T")$
#let ht = $bold("HT")$

#let norm = $bold("norm")_beta$
#let nnorm = $bold("nnorm")_beta$
#let hn = $bold("HN")$

#let tred(c) = text(fill: red.darken(10%), c)
#let tblue(c) = text(fill: blue.darken(10%), c)
#let tgreen(c) = text(fill: green.darken(10%), c)


#title-slide(
  footer: [
    Following #link("https://www.cs.cmu.edu/~rwh/courses/atpl/pdfs/tait.pdf")[Harper (2025)]
    #h(1fr)
    Presented by Yanning Chen \@ ProSE Seminar
  ],
)[
  == An Introduction to Logical Relations

  == by (Re-)Inventing the Tait Method
]

== STLC

#box(width: 1fr)[
  #align(
    center,
    text(size: 0.9em)[
      $
        (x in Gamma) / (Gamma tack.r x: A) #msmcp("Var") quad
        "" / (Gamma tack.r "yes": "ans") #msmcp("Yes") quad
        "" / (Gamma tack.r "no": "ans") #msmcp("No") quad
        "" / (Gamma tack.r ⟨⟩: 1) #msmcp("Unit")
      $
      $
        (Gamma tack.r M_1: A quad Gamma tack.r M_2: B) / (Gamma tack.r (M_1, M_2): A times B) #msmcp("Prod") quad
        (Gamma tack.r M: A times B) / (Gamma tack.r M.1: A) #msmcp("Prj1") quad
        (Gamma tack.r M: A times B) / (Gamma tack.r M.2: B) #msmcp("Prj2")
      $
      $
        (Gamma, x: A tack.r M: B) / (Gamma tack.r lambda x. M: A -> B) #msmcp("Abs") quad
        (Gamma tack.r M: A -> B quad Gamma tack.r N: A) / (Gamma tack.r M N: B) #msmcp("App")
      $

      (Also, denote head $beta$-reduction as $M |-> N$)
    ],
  )
]

== Type Safety of STLC

*Theorem* (Termination of STLC):\
If $emptyset tack.r M: "ans"$, then either $M |->^* "yes"$ or $M |->^* "no"$.

*Lemma* (Progress of STLC):\
If $emptyset tack.r M: A$, then either $#value M$ or $exists N, M |-> N$.

*Lemma* (Preservation of STLC):\
If $emptyset tack.r M: A$ and $M |-> N$, then $emptyset tack.r N: A$.

#let debug = context {
  let h = utils.slide-counter.get()
  let n = utils.last-slide-counter.final()
  [
    slide-counter: #h
    last-slide-counter: #n
  ]
}

#debug

== Type Safety of STLC

*Theorem* (Termination of STLC):\
If $emptyset tack.r M: "ans"$, then either $M |->^* "yes"$ or $M |->^* "no"$.

*Syntactic Approach*: Progress + Preservation, but not accounting for non-divergence!

*Semantic Approach*: direct proof (via logical relations)

== Termination, attempt 1

*Theorem* (Termination of STLC):\
If $emptyset tack.r M: "ans"$, then either $M |->^* "yes"$ or $M |->^* "no"$.

*Proof*:\
#pause
By induction on the derivation of $emptyset tack.r M: "ans"$.
- Case #msmcp("Yes") and #msmcp("No"): trivial.
#pause
- Case #msmcp("Lft"):\
  IH: if $"ans" = "ans" times B$ and $emptyset tack.r M: "ans"$, then either $M |->^* "yes"$ or $M |->^* "no"$. ???

== Termination, attempt 2 (generalizing the type)

*Theorem* (Termination of STLC):\
If $emptyset tack.r M: A$, then $exists N$, $M |->^* N$ and $#value N$, where

#box(width: 1fr)[
  #align(
    center,
    text(size: 0.9em)[
      $
        "" / (#value "yes") #msmcp("Yes") quad
        "" / (#value "no") #msmcp("No") quad
        "" / (#value ⟨⟩) #msmcp("Unit")
      $
      $
        "" / (#value ⟨M_1, M_2⟩) #msmcp("Prod") quad
        "" / (#value lambda x. M) #msmcp("Lam")
      $
    ],
  )
]

*Proof*:
#alternatives(start: 2)[
  - Case #msmcp("Lft"):\
    Assume: $emptyset tack.r M: A times B$\
    IH: $exists N$, $M |->^* N$ and $#value N$.\
    wts. $exists N^?$ s.t. $M.1 |->^* N^?$ and $#value N^?$.
][
  - Case #msmcp("Lft"):\
    $exists N_1 N_2$, $M |->^* ⟨N_1, N_2⟩$ (by IH, preservation and #value)\
    wts. $M.1 |->^* N_1$ and $#value N_1$. ???
]

== Termination, attempt 3 (strengthening #value)

*Conjecture* (Termination of STLC?):\
If $emptyset tack.r M: A$, then $exists N$, $M |->^* N$ and $svalue N$
#only("1")[, where

  #box(width: 1fr)[
    #align(
      center,
      text(size: 0.9em)[
        $
          "" / (svalue "yes") #msmcp("Yes") quad
          "" / (svalue "no") #msmcp("No") quad
          "" / (svalue ⟨⟩) #msmcp("Unit")
        $
        $
          (svalue M_1 quad svalue M_2) / (svalue ⟨M_1, M_2⟩) #msmcp("Prod") quad
          ? / (svalue lambda x. M) #msmcp("Lam")
        $
      ],
    )
  ]
]

#only("2-")[
  - Consider $(svalue M_1 quad svalue M_2) / (svalue ⟨M_1, M_2⟩) #msmcp("Prod")$

    ? What about $⟨⟨Y, N⟩.1, dots⟩$
]
#only("3")[
  - Consider $? / (svalue lambda x. M) #msmcp("Lam")$

    How to fill the hole?

    $(svalue M[N"/"x]) / (svalue lambda x. M) #msmcp("Lam") $? $(quad M[N"/"x] |->^* M' quad svalue N => svalue M') / (svalue lambda x. M) #msmcp("Lam") $?
]

== A better #svalue

*Theorem* (Termination of STLC):\
If $emptyset tack.r M: A$, then $exists N$, $M |->^* N$ and $svalue N$

#box(width: 1fr)[
  #align(
    center,
    text(size: 0.9em)[
      $
        "" / (svalue "yes") #msmcp("Yes") quad
        "" / (svalue "no") #msmcp("No") quad
        "" / (svalue ⟨⟩) #msmcp("Unit")
      $
      $
        (M_1 |->^* M'_1 quad M_2 |->^* M'_2 quad svalue M'_1 quad svalue M'_2) / (svalue ⟨M_1, M_2⟩) #msmcp("Prod")
      $
      $
        (M[N"/"x] |->^* M' quad svalue N => svalue M') / (svalue lambda x. M) #msmcp("Lam")
      $
    ],
  )
]

*Note*: $=>$ means _meta-level implication_.

== #st: $|->$ + #svalue

#only("1")[
*Theorem* (👍 Termination of STLC):\
If $emptyset tack.r M: A$, then $st M$.
]

#box(width: 1fr)[
  #align(
    center,
    text(size: 0.9em)[
      $
        (M |->^* "yes") / (st M) #msmcp("Yes") quad
        (M |->* "no") / (st M) #msmcp("No") quad
        (M |->^* ⟨⟩) / (st M) #msmcp("Unit")
      $
      $
        (M |->^* ⟨M_1, M_2⟩ quad st M_1 quad st M_2) / (st M) #msmcp("Prod")
      $
      $
        (M |->^* lambda x. M' quad st N => st M'[N"/"x]) / (st M) #msmcp("Lam")
      $
    ],
  )
]

#only("2")[
  Problem: #st is undecidable and hard to reason!

  If only we can know the _intended canonical form_ of a term in advance...
]

== Hereditary Termination (#ht: type-indexed #st)

*Conjecture* (?Hereditary Termination of STLC):\
If $emptyset tack.r M: A$, then $ht_A M$.

#alternatives[
  #box(width: 1fr)[
    #align(
      center,
      text(size: 0.9em)[
        $
          (M |->^* "yes") / (ht_"ans" (M)) #msmcp("Yes") quad
          (M |->* "no") / (ht_"ans" (M)) #msmcp("No") quad
          (M |->^* ⟨⟩) / (ht_1 (M)) #msmcp("Unit")
        $
        $
          (M |->^* ⟨M_1, M_2⟩ quad ht_A (M_1) quad ht_B (M_2)) / (ht_(A times B) (M)) #msmcp("Prod")
        $
        $
          (M |->^* lambda x. M' quad ht_A (N) => ht_B (M'[N"/"x])) / (ht_(A -> B) (M)) #msmcp("Lam")
        $
      ],
    )
  ]
][
  #box(width: 1fr)[
    #align(
      center,
      text(size: 0.9em)[
        $
          ht_"ans" (M) := M |->^* "yes"$ or $M |->^* "no" quad
          ht_1 (M) := M |->^* ⟨⟩ quad
        $

        $ ht_(A times B) (M) := M |->^* ⟨M_1, M_2⟩$ and $ht_A (M_1)$ and $ht_B (M_2) $

        $ ht_(A -> B) (M) := M |->^* lambda x. M'$ and $ht_A (N) => ht_B (M'[N"/"x]) $

      ],
    )
  ]
]

== Termination, attempt 4 (plain HT)

*Conjecture* (?Hereditary Termination of STLC):\
If $emptyset tack.r M: A$, then $ht_A (M)$.

*Proof*:

- Case #msmcp("Lft"):

  Assume $emptyset tack.r M: A times B$, by IH $ht_(A times B) (M)$\
  wts. #tred($ht_A (M.1)$)

  #pause
  By $ht_(A times B)(M)$, we know $M |->^* ⟨M_1, M_2⟩$ and #tblue($ht_A (M_1)$),\
  and observe that $tred(M.1) |->^* ⟨M_1, M_2⟩.1 |-> tblue(M_1)$.

  #pause
  💡 It suffices to show that #ht is closed under "reverse execution".

== Head Expansion a.k.a. "reverse execution"

*Lemma* (Head Expansion):\
If $tred(M) |->^* tblue(N)$ and #tblue($ht_A (N)$), then #tred($ht_A (M)$).

*Proof*: by definition of #ht.

#box(width: 1fr)[
  #align(
    center,
    text(size: 0.9em)[
      $
        ht_"ans" (M) := M |->^* "yes"$ or $M |->^* "no" quad
        ht_1 (M) := M |->^* ⟨⟩ quad
      $

      $ ht_(A times B) (M) := M |->^* ⟨M_1, M_2⟩$ and $ht_A (M_1)$ and $ht_B (M_2) $

      $ ht_(A -> B) (M) := M |->^* lambda x. M'$ and $ht_A (N) => ht_B (M'[N"/"x]) $

    ],
  )
]

== Termination, attempt 4 (plain HT)

*Conjecture* (?Hereditary Termination of STLC):\
If $emptyset tack.r M: A$, then $ht_A (M)$.

*Proof*:

- Case #msmcp("Lam"):

  IH2: if #tred($emptyset = emptyset, x: A$) and $emptyset, x: A tack.r M: B$, then $ht_B (M)$\
  wts. $ht_(A -> B) (lambda x. M)$ ???

  #pause
  !! Need to generalize over $Gamma$, but #ht applies only to closed terms!

== How to deal with open terms?

Given subst $gamma$ from variables to terms,\
we say $Gamma' tack.r gamma: Gamma$ iff $forall x: A in Gamma, Gamma' tack.r gamma(x): A$.

#alternatives[
  *Subst Lemma*:\
  $
    (Gamma' tack.r gamma: Gamma quad Gamma tack.r M: A) / (Gamma' tack.r M[gamma]: A)
  $
][
  *Subst Lemma* (specialized):\
  $
    (emptyset tack.r gamma: Gamma quad Gamma tack.r M: A) / (emptyset tack.r M[gamma]: A)
  $
][
  *Idea*: adopting _subst lemma_ to #ht,
  $
    (ht_Gamma (gamma) quad tgreen(Gamma >> M in A))/(ht_A (M[gamma]))
  $

  where $ht_Gamma (gamma) := forall x: A in Gamma, ht_A (x[gamma])$
][
  *Idea*: adopting _subst lemma_ to #ht,
  $
    Gamma >> M in A := ht_Gamma (gamma) => ht_A (M[gamma])
  $

  where $ht_Gamma (gamma) := forall x: A in Gamma, ht_A (x[gamma])$
]

== Hereditary Termination, finally

*Theorem* (FTLR of #ht, or Hereditary Termination of STLC):\
If $Gamma tack.r M: A$, then $Gamma >> M in A$. #text(size: 0.7em)[(where $Gamma >> M in A := ht_Gamma (gamma) => ht_A (M[gamma])$)]

*Proof*:
#alternatives[
- Case #msmcp("Var") ($Gamma >> alpha in A$):\
  By assumption, $alpha: A in Gamma$. Assume $ht_Gamma (gamma)$, wts. $ht_A (alpha[gamma])$.\
  So $gamma(alpha) = M$ s.t. $ht_A (M)$. But, #tred[$alpha[gamma] = gamma(alpha)$]. We are done.
][
- Case #msmcp("Lam") ($Gamma >> lambda x. M: A -> B$):\
  #tblue[Assume $ht_Gamma (gamma)$], wts. $ht_(A->B) (lambda x. M[gamma])$. By definition of $ht_(A->B)$, #tblue[assume $ht_A (N)$], wts. $ht_B (M[gamma][N "/" x])$.\
  By I.H., $forall gamma', ht_(Gamma, x: A) (gamma')$ implies $ht_B (tgreen(M[gamma']))$. Specializing I.H. by $gamma' := gamma, x -> N$, and note that #tblue[$ht_(Gamma, x: A)(gamma')$], we have $ht_B (tgreen(M[gamma, x -> N]))$, and $ht_B (M[gamma][N "/" x])$.

  *Idea*: apply $gamma$ from premises (by I.H.) to the conclusion.
]


== From Termination to (Weak) $beta$-Normalizing

*Termination*: _head_ $beta$-reduction of well-typed _closed terms_ stops at canonical forms (#value).

*Normalization*: _full_ $beta$-reduction of well-typed _open terms_ stops at $beta$-normal forms (can not step anymore).

#align(center)[
  #box(width: 1fr)[
    $
      (M_2 ->_beta M'_2) / (M_1 tred(M_2) ->_beta M_1 tred(M'_2)) #msmcp("App2") quad
      (M ->_beta M') / (lambda x. tred(M) ->_beta lambda x. tred(M')) #msmcp("Abs")
    $

    $
      (M_1 ->_beta M'_1) / (⟨tred(M_1), M_2⟩ ->_beta ⟨tred(M'_1), M_2⟩) #msmcp("ProdL") quad
      (M_2 ->_beta M'_2) / (⟨M_1, tred(M_2)⟩ ->_beta ⟨M_1, tred(M'_2)⟩) #msmcp("ProdR")
    $
  ]
]

== Normalization of STLC, formally

*Normalization*: _full_ $beta$-reduction of well-typed _open terms_ stops at $beta$-normal forms (can not step anymore).

_Formally_, define
$#norm (M) := exists N, M arrow_beta^* N$ and $N arrow.not_beta$

*Theorem* (Normalization of STLC):\
If $Gamma tack.r M: A$, then $#norm (M)$.

by proving the following lemma

== From #ht to #hn: Kripke LR

$ht_A (M)$ only applies to _closed terms_, while $#hn$ must deal with _open terms_.

*Solution* (Kripke LR): index over free variables ($Delta$), or _"possible worlds"_.

$hn_A^Delta (M)$ is indexed by variable contexts $Delta$ and types $A$ on well-formed terms $Delta tack.r M: A$.

== Hereditary Normalizing (#hn)

#box(width: 1fr)[
  #align(
    center,
    text(size: 0.9em)[
      $
        ht_"ans" (M) := M |->^* "yes"$ or $M |->^* "no" quad
        ht_1 (M) := M |->^* ⟨⟩ quad
      $

      $ ht_(A times B) (M) := tblue(M |->^* ⟨M_1, M_2⟩)$ and $ht_A (tgreen(M_1))$ and $ht_B (tgreen(M_2))$

      $ ht_(A -> B) (M) := tblue(M |->^* lambda x. M')$ and $ht_A (N) => ht_B (tgreen(M'[N"/"x]))$

    ],
  )
]

#box(width: 1fr)[
  #align(
    center,
    text(size: 0.9em)[
      $
        hn_"ans"^Delta (M) := #norm (M) quad
        hn_1^Delta (M) := #norm (M)
      $

      $ hn_(A times B)^Delta (M) := hn_A^Delta (tred(M.1))$ and $hn_B^Delta (tred(M.2))$

      $ hn_(A -> B)^Delta (M) := tred(forall Δ' <= Δ), hn_A^tred(Delta')(N) => hn_B^tred(Delta')(tred(M N))$

    ],
  )
]

== #hn vs #ht

#alternatives(stretch: false)[
  - $hn_(A times B)^Delta (M) := hn_A^Delta (tred(M.1))$ and $hn_B^Delta (tred(M.2))$ vs $ht_(A times B) (M) := tblue(M |->^* ⟨M_1, M_2⟩)$ and $ht_A (tgreen(M_1))$ and $ht_B (tgreen(M_2))$

    $M$ might be a variable, so it probably won't reduce to canonical form.
    Define #hn via elimination instead of introduction.

    $
      (Gamma tack.r M_1: A quad Gamma tack.r M_2: B) / (Gamma tack.r (M_1, M_2): A times B) #tgreen(msmcp("Prod"))
    $
    $
      (Gamma tack.r M: A times B) / (Gamma tack.r M.1: A) #tred(msmcp("Prj1")) quad
      (Gamma tack.r M: A times B) / (Gamma tack.r M.2: B) #tred(msmcp("Prj2"))
    $
][
  - $hn_(A -> B)^Delta (M) := tred(forall Δ' <= Δ), hn_A^tred(Delta')(N) => hn_B^tred(Delta')(M N)$

    $Delta' <= Delta := forall x, Delta tack.r x: A => Delta' tack.r x: A$, i.e. $Delta'$ is an extension of $Delta$.

    Intuitively: a function can be applied in a larger context by weakening lemma.

    *Lemma* (Anti-Monotonicity):\
    If $hn_A^Delta(M)$ and $Delta' <= Delta$, then $hn_A^Delta'(M)$.
]

== Head Expansion for #hn

*Lemma* (Head Expansion):\

If $tred(M) tgreen(|->^*) tblue(N)$ and #tblue($hn_A^Delta (N)$), then #tred($hn_A^Delta (M)$).

*Proof*: 👋.

💡 It suffices to show that #hn is closed under _head expansion_ instead of _full expansion_.

== FTLR of #hn

*Theorem* (FTLR of #hn, or Hereditary Normalizing of STLC):\

If $Gamma tack.r M: A$, then $forall Delta, hn_Gamma^Delta (gamma) => hn_A^Delta (M[gamma])$.

*Proof*: 👋.

== One Missing Step: From Hereditary-$cal(P)$ to $cal(P)$

*Theorem* (FTLR of #ht)\
If $Gamma tack.r M: A$, then $Gamma >> M in A$. #text(size: 0.7em)[(where $Gamma >> M in A := ht_Gamma (gamma) => ht_A (M[gamma])$)]

*Theorem* (Termination of STLC)\
If $emptyset tack.r M: "ans"$, then either $M |->^* "yes"$ or $M |->^* "no"$.

#pause
*Proof*:\
Instantiating FTLR with $Gamma = emptyset$ and $A = "ans"$, $ht_emptyset (gamma) => ht_A (M[gamma])$\
$ht_emptyset (gamma)$ holds trivially, and $M[gamma] = M$ because $M$ is closed, so $ht_A (M)$.

Now we are done by the definition of #ht.\
$square$

== From #hn to Normalizing?

Not so easy!

$hn_(A times B)^Delta (M) := hn_A^Delta (tred(M.1))$ and $hn_B^Delta (tred(M.2))$ vs $ht_(A times B) (M) := tblue(M |->^* ⟨M_1, M_2⟩)$ and $ht_A (tgreen(M_1))$ and $ht_B (tgreen(M_2))$

+ #ht works on closed term, thus the precondition is trivial, while #hn is not.
+ #ht is defined by introduction, which means we have direct information about $M$ itself, while #hn is defined by elim form like $M.1$.

== From #hn to Normalizing?

*Theorem* (FTLR of #hn)\
If $Gamma tack.r M: A$, then $forall Delta, hn_Gamma^Delta (gamma) => hn_A^Delta (M[gamma])$.

*Theorem* (Normalization of STLC)\
If $Gamma tack.r M: A$, then $#norm (M)$.

#pause
*Proof*:\
It suffices to show that
+ $hn_Gamma^Gamma (iota)$, where $iota(x) = x$ (i.e., $Gamma tack.r iota : Gamma$)
+ (Adaquacy) If $Gamma tack.r M: A$ and $hn_A^Delta (M)$, then $norm(M)$

== $hn_Gamma^Gamma (iota)$

*Theorem*: $forall x: A in Gamma, hn_A^Gamma (x)$\
(every variable in $Gamma$ is hereditarily normalizing at its claimed type).

*Proof*:\
By case analysis on $A$.
#alternatives[
- Case #msmcp("Ans"):\
  Assume $alpha: "ans" in Gamma$, wts. $hn_"ans"^Gamma (alpha)$, which is to show $norm(alpha)$, and it follows directly from the definition of $norm$.
][
- Case #msmcp("Prod"):\
  Assume $alpha: A times B in Gamma$, wts. $hn_(A times B)^Gamma (alpha)$. It suffices to show $hn_A^Gamma (alpha.1)$ and $hn_B^Gamma (alpha.2)$.
- Case #msmcp("Lam") ($hn_(A -> B)^Gamma (alpha)$):\
  Assume $forall Gamma' <= Gamma, hn_A^Gamma' (M)$.
  It suffices to show that $hn_B^Gamma' (alpha M)$.\
  Applying adaquacy to assumption, we have $norm(M)$.
]

== So, to prove $hn_Gamma^Gamma (iota)$

We want to show that\
$hn_A^Gamma (alpha.1)$, $hn_A^Gamma (alpha.2)$, and $norm(M) => hn_A^Gamma' (alpha M)$

#pause

Generalize it a bit, we define _neutral term_ $U := x | U.1 | U.2 | U M$ as terms that stuck regarding head reduction.

And we can define _normalizable neutral term_ $nnorm$:

$nnorm(x) := top$\
$nnorm(U.1) := nnorm(U) quad nnorm(U.2) := nnorm(U)$\
$nnorm(U M) := nnorm(U)$ and $tred(norm)(M)$

And we prove that if $nnorm(U)$, then $hn_A^Delta (U)$

== Pas-de-deux, or the Dance of #norm and #hn

*Lemma* (Pas-de-deux): $forall A$ and $Δ tack.r U, M: A$,
+ #tred[If $nnorm(U)$, then $hn_A^Delta (U)$]
+ #tblue[If $hn_A^Delta (M)$, then $norm(M)$]

*Proof*: By induction on A,
- Case #msmcp("Lam"):
  + ($hn_(A -> B)^Delta (U)$) Assume $nnorm(U)$. Let $Δ' <= Δ$, it suffices to show that $hn_A^Delta' (N)$ implies $hn_B^Delta'(U N)$. #tblue[By induction (2), $norm(N)$], thus $nnorm(U N)$. #tred[By induction (1), $hn_B^Delta'(U N)$].
  + ($norm(M)$) Assume $hn_(A -> B)^Delta (M)$. Let $Delta' := Delta, x: A <= Delta$, we have $hn_B^Delta' (M x)$, and #tblue[by induction (2), $norm(M x)$]. By definition, $nnorm(x)$, so #tred[by induction (1), $hn_A^Delta' (x)$]. Then by analysis on $beta$-reduction, $norm(M)$.

== From #hn to Normalizing

*Theorem* (Normalization of STLC)\
If $Gamma tack.r M: A$, then $#norm (M)$.

*Proof*:\
It suffices to show that
+ $hn_Gamma^Gamma (iota)$
+ (Adaquacy) If $Gamma tack.r M: A$ and #tblue[$hn_A^Delta (M)$, then $norm(M)$]

Both follows from the _pas-de-deux lemma_.

== Logical Relation, generalized on $cal(P)$

*Conjecture* If $Gamma tack.r M: A$, then $cal(P)_A^Gamma (M)$.

*Proof*: Define LR _hereditarily_ $cal(P)$ as $h cal(P)_A^Delta (M)$.

$h cal(P)_1^Delta(M) := M |->^* ⟨⟩$ or $M |->^* U$ and $n cal(P)_1^Delta(U)$\
$h cal(P)_(A times B)^Delta (M) := h cal(P)_A^Delta (M.1)$ and $h cal(P)_B^Delta (M.2)$\
$h cal(P)_(A -> B)^Delta (M) := forall Delta' <= Delta$, if $h cal(P)_A^Delta' (N)$, then $h cal(P)_B^Delta' (M N)$

Where $n cal(P)$ (_neutrally_ $cal(P)$) requires that the argument terms of $U$ to be $h cal(P)$:

$n cal(P)_A^(Delta, alpha: A) (alpha) := top$\
$n cal(P)_A^Delta (U.1) := n cal(P)_(A times B)^Delta (U)$\
$n cal(P)_B^Delta (U.2) := n cal(P)_(A times B)^Delta (U)$\
$n cal(P)_B^Delta (U M) := n cal(P)_(A -> B)^Delta (U)$ and $h cal(P)_A^Delta (M)$

== Reduction Property $cal(P)$

By concluding from our previous proof of _FTLR_ and _pas-de-deux_, both hold for $cal(P)$ if:

+ $P_1^Delta (⟨⟩)$.
+ If $n cal(P)_1^Delta (U)$, then $cal(P)_1^Delta (U)$.
+ If $cal(P)_A^Delta (M.1)$ and $cal(P)_B^Delta (M.2)$, then $cal(P)_(A times B)^Delta (M)$.
+ If $cal(P)_B^(Delta, x: A) (M x)$, then $cal(P)_(A -> B)^Delta (M)$.

We call this kind of property _reduction property_. So,

*Theorem* (Principle of _reduction property_)\
Given _reduction property_ $cal(P)$, if $Gamma tack.r M: A$, then $cal(P)_A^Gamma (M)$.

== Conclusion

- To prove termination of STLC: logical relation $ht$.
- To prove normalization of STLC: Kripke-style LR $hn$.
- From _FTLR_ of $hn$ to normalization: _pas-de-deux_.
- LR as a general principle: _reduction property_.

Interesting applications:
+ _Strong normalizing_ is a _reduction property_.
+ Verify safety of ill-typed programs (think _RustBelt_).
+ LR indexed by source types but on target terms (think _FFI_).

== Related Material

- _Harper, Robert. "How to (Re)Invent Tait's Method"._ #link("https://www.cs.cmu.edu/~rwh/courses/atpl/pdfs/tait.pdf")[\[Link\]]\ 
  Define _Hereditary Termination_ #ht
- _Harper, Robert. "Kripke-Style Logical Relations for Normalization"._ #link("https://www.cs.cmu.edu/~rwh/courses/atpl/pdfs/kripke.pdf")[\[Link\]]\
  Define _Hereditary Normalizing_ #hn
- _Harper, Robert. "Strong Normalization as Transfinite Induction on Reduction"._ #link("https://www.cs.cmu.edu/~rwh/courses/atpl/pdfs/tir.pdf")[\[Link\]]\
  Generalized LR, and an old but general approach to prove _$beta$-confluence_ via _transfinite $->$-induction_ (property that satisfies _head expansion_).
- _Harper, Robert. "How to (Re)Invent Girard's Method"._ #link("https://www.cs.cmu.edu/~rwh/courses/atpl/pdfs/girard.pdf")[\[Link\]]\
  LR for _System F_.